<?php

class TestModel extends CFormModel
{
	public $pesel;

	public function rules()
	{
		return array(
			array('pesel', 'ext.Validators.PeselValidator'),
		);
	}
}

class TestModelNoCk extends CFormModel
{
	public $pesel;

	public function rules()
	{
		return array(
			array('pesel', 'ext.Validators.PeselValidator', 'disableChecksum' => true),
		);
	}
}

class PeselValidatorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @dataProvider dataProviderTestValidateAttribute
	 */
	public function testValidateAttribute($pesel, $errors, $class = 'TestModel')
	{
		$model = new $class();
		$model->pesel = $pesel;
		$this->assertEquals($pesel, $model->pesel);
		$model->validate();
		$this->assertEquals($model->errors, $errors);
	}

	public function dataProviderTestValidateAttribute()
	{
		static $data = array(
			//bad
			array('qwertyuiopa', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('invalid pesel', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('1234', array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			array('', array()),
			array(null, array()),
			array(0, array()),
			array(false, array()),
			array(123, array('pesel'=>array('Pole Pesel jest nieprawidłowe.'))),
			//good string
			array('79112159511', array()),
			array('65071098482', array()),
			array('77042203032', array()),
			//good number
			array(25053191628, array()),
			array(79012972735, array()),
			//bad string
			array('79112150511', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array('65171098482', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array('77242203032', array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			//bad number
			array(25153191628, array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			array(79012872735, array('pesel'=>array('Pole Pesel ma niepoprawną sumę kontrolną.'))),
			//no ck
			array('79112150511', array(), 'TestModelNoCk'),
			array('65171098482', array(), 'TestModelNoCk'),
			array('77242203032', array(), 'TestModelNoCk'),
			array('qwertyuiopa', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCk'),
			array('invalid pesel', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCk'),
			array('1234', array('pesel'=>array('Pole Pesel jest nieprawidłowe.')), 'TestModelNoCk'),
		);
		return $data;
	}
}
